#!/bin/bash
config() {
  NEW="$1"
  OLD="${NEW%.new}"
  # If there is no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(md5sum $OLD)" = "$(md5sum $NEW)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the new copy for the admin to consider...
    }

test -s install/conffiles && {
    while read Datei
	do
	config ./$Datei.new
	done < install/conffiles
	}
    test -s install/postinst && sh install/postinst configure
    
#

